<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
class Ldap {
#TODO - ASK ADAM ABOUT MAKING CONNESTEOR VUBLICLY ACCESSIBLE.  BETTER TO BE PRIVATE & PROVIDE ACCESSOR METHOD?
	public $conn;
	private $CI;
	public function __construct($credentials = array()){	
		$this->CI =& get_instance();
		$this->CI->load->library("session");
		$this->error =& $this->CI->error;
		$this->is =& $this->CI->is;
		
		extract($credentials);
		if(empty($user) || empty($pwd)){
			extract($this->CI->user_model->ldap_credentials());
		}

		//$this->connect_to_ldap_as_admin();


		//try logging in with the user's account
		if($user != LDAP_SEARCH_USERNAME){
			$this->conn = $this->connect_to_ldap($user,$pwd,TRUE);
		}
		
		
		//if we're not connected, try the default LDAP search user
		if(!$this->connected()){
			$this->conn = $this->connect_to_ldap(LDAP_SEARCH_USERNAME,LDAP_SEARCH_PASSWORD);
		} 
		
#TODO - MAKES SENSE TO HAVE ERROR HERE? BETTER ERROR MESSAGE?
		//if we still can't connect, show an error message to the user
		if(!$this->connected()){
			$this->error->error('Unable to connect to LDAP server');
			$message_to_users = 'The system is currently unavailable.  Please try again later. '.
								'If you continue to see this message, please contact the system administrators.';	
			show_error($message_to_users);
		} 
	}
	
	public function connected() {
		if(!$this->conn) { return FALSE; }
		else { return TRUE; }
	}
	
	public function get_ldap_error() {
		return ldap_error($this->conn);
	}
	
	public function has_ldap_error(){
		return ldap_errno($this->conn) != 0;
	}
	
	public function create_ldap_account($attributes) {
		return ldap_add($this->conn, "uid=" . $attributes["uid"] . "," . LDAP_ACCOUNTS_DN,$attributes);	
	}
	
	public function create_group($attributes) {
		return ldap_add($this->conn, "ou=" . $attributes['ou'] . "," . LDAP_GROUPS_DN,$attributes);	
	}
	
	public function modify_ldap_account($uid,$attributes,$dn = NULL) {
        if(is_null($dn)) { $dn = LDAP_ACCOUNTS_DN; }
		//assumes you would like to remove attributes with no value specified
		foreach($attributes as $key => $attribute) {
			if(strlen(trim($attribute)) == 0) { 
				$attributes_to_remove[$key] = array();
				$remove = @ldap_mod_del($this->conn,"uid=" . $uid . "," . $dn,$attributes_to_remove); //remove blank attribute if it exists, ignore warnings when attribute doesn't exist
				unset($attributes[$key]); //take it out of the list of attributes to update as blanks will cause the modify function to break
			}
			$attributes_to_remove = array();
		}
		$modify = ldap_modify($this->conn, "uid=" . $uid . "," . $dn,$attributes);
		return $modify;
	}
	
	public function delete_ldap_account($uid) {
		if($this->conn) {
			$dn = 'uid='.$uid.','.LDAP_ACCOUNTS_DN;
			$sr = @ldap_search($this->conn, LDAP_BASE_DOMAIN, '(&(member='.$dn.'))', array('dn'));
			if($sr !== FALSE) {
				$info = ldap_get_entries($this->conn, $sr);
				for($i = 0; $i < $info['count']; $i++) {
					ldap_mod_del($this->conn,$info[$i]['dn'],array("member" => "uid=" . $uid . "," . LDAP_ACCOUNTS_DN));
				}
			}
			return ldap_rename($this->conn, "uid=" . $uid . "," . LDAP_ACCOUNTS_DN,"uid=" . $uid,LDAP_DELETED_ACCOUNTS_DN, TRUE);
		}
	}
	
	public function restore_ldap_account($uid) {
		return ldap_rename($this->conn, "uid=" . $uid . "," . LDAP_DELETED_ACCOUNTS_DN,"uid=" . $uid,LDAP_ACCOUNTS_DN, TRUE);
	}
	
	public function search($search = NULL,$sizelimit = NULL, $properties = NULL, $filter = NULL, $dn = NULL) {
		if(is_null($properties)) { $properties = array("mail","displayname","objectclass"); }
		if(is_null($search)) { $search = ""; }
		if($this->conn) {
			if(is_null($dn)) { $dn = LDAP_ACCOUNTS_DN; }
			if(is_null($filter)) { $filter="(&(ObjectClass=person)(|(displayName=" . $search . "*)(mail=" . $search . "*)))"; }
			$cookie = "";
			$result_arr = array();

			$j = 0;
			//NOTE: commented out code should allow paged LDAP results in PHP 5.4+ which will allow a full result set to be returned
			//This should not be needed in the pilot, but could be useful in the future, so it has been included. It is untested however.
			//while($cookie !== null && $cookie != "") {
			//	ldap_control_paged_result($this->conn,1000,true,$cookie);
				$sr = @ldap_search($this->conn, $dn, $filter, $properties, NULL, $sizelimit);
				if($sr === FALSE) {
					log_message('error', 'ldap search failed');
				}
				else {
					ldap_sort($this->conn, $sr, 'displayname');
					$info = ldap_get_entries($this->conn, $sr);
					for($i = $j; $i < $info["count"]; $i++) {
						foreach($info[$i] as $key => $val) {
							if(is_array($val) && $val['count'] == 1) {
								$result_arr[$i][$key] = $val[0];
							}
							else if(is_array($val) && $val['count'] > 1) {
								for($k = 0; $k < $val['count']; $k++) {
									$result_arr[$i][$key][$k] = $val[$k];
								}
							}
							else {
								$result_arr[$i][$key] = $val;
							}
						}
					}
				}
			//	 ldap_control_paged_result_response($this->conn, $sr, $cookie);
			//}		
			return $result_arr;
		}
		return false;
	}
	
	public function get_group_membership($dn) {
		if($this->conn) {
			//assume bind has already happened and we can do a search			
			$search = ldap_search($this->conn, LDAP_GROUPS_DN, '(&(member='.$dn.'))', array('ou','cn'));
			if(!is_resource($search)) return array();
			$entries = ldap_get_entries($this->conn, $search);
			$groups = array();
			foreach($entries as $entry) {
				for($i = 0; $i < $entry['ou']['count']; $i++) {
					$group = $entry['ou'][$i];
					$groups[$group] = $group;
				}
				for($i = 0; $i < $entry['cn']['count']; $i++) {
					$groups[$group] = $entry['cn'][$i];
				}
			}
			return $groups;
		}
	}
	
	public function get_admin_group_membership($dn) {
		if($this->conn) {
			//assume bind has already happened and we can do a search
			$search = ldap_search($this->conn, LDAP_ADMIN_GROUP1, "(&(member=" . $dn . "))", array("cn"));
			if(!is_resource($search)) return array();
			$entries = ldap_get_entries($this->conn, $search);
			return $entries;
		}
	}
	
	public function set_admin_group_membership($uid,$level) {
		if($this->conn) {
			if($level == 0) { 
				return ldap_mod_del($this->conn,LDAP_ADMIN_GROUP1,array("member" => "uid=" . $uid . "," . LDAP_ACCOUNTS_DN));
			}
			else if($level == 1) {
				return ldap_mod_add($this->conn,LDAP_ADMIN_GROUP1,array("member" => "uid=" . $uid . "," . LDAP_ACCOUNTS_DN)); 
			}
		}
	}
	
	public function add_group_membership($group,$uid,$dn = NULL) {
		if(is_null($dn)) { $dn = LDAP_GROUPS_DN; }
		if($this->conn) {
			echo 'ou=' . $group . ','.$dn;
			return ldap_mod_add($this->conn,'ou='.$group .','.$dn,array("member" => "uid=".$uid.",".LDAP_ACCOUNTS_DN));
		}
	}
	
	public function remove_group_membership($group,$uid,$dn = NULL) {
		if(is_null($dn)) { $dn = LDAP_GROUPS_DN; }
		if($this->conn) {
			return ldap_mod_del($this->conn,'ou=' . $group . ','.$dn,array("member" => "uid=" . $uid . "," . LDAP_ACCOUNTS_DN));
		}
	}
	
	public function modify_group($ou,$attributes,$dn = NULL) {
        if(is_null($dn)) { $dn = LDAP_GROUPS_DN; }
		//assumes you would like to remove attributes with no value specified
		$attributes_to_remove = array();
		foreach($attributes as $key => $attribute) {
			if(strlen(trim($attribute)) == 0) { 
				$attributes_to_remove[$key] = array(); 
				unset($attributes[$key]);
			}
		}
		$remove = ldap_mod_del($this->conn,"ou=" . $ou . "," . $dn,$attributes_to_remove);
		$modify = ldap_modify($this->conn, "ou=" . $ou . "," . $dn,$attributes);
		return $remove && $modify;
	}
	
	public function remove_group($group) {
		if($this->conn) {
			return ldap_rename($this->conn, "ou=" . $group . "," . LDAP_GROUPS_DN,"ou=" . $group,LDAP_DELETED_GROUPS_DN, TRUE);
		}
	}
	public function restore_group($group) {
		if($this->conn) {
			return ldap_rename($this->conn, "ou=" . $group . "," . LDAP_DELETED_GROUPS_DN,"ou=" . $group,LDAP_GROUPS_DN, TRUE);
		}
	}

	public function get_formatted_entries($search_result_resource, $key_by = null){
		if(!is_null($key_by) && !$this->is->nonempty_string($key_by)) return $this->error->should_be_a_nonempty_string($key_by);
		//if we're not given a resource, the ldap search query may have failed
		//it will have already triggered an error, so just return an empty array
		if(!is_resource($search_result_resource)) return array(); 
		
		$entries = ldap_get_entries($this->conn, $search_result_resource);
		if(!$this->is->nonzero_unsigned_integer(element('count', $entries, 0))) return array();
		
		$formatted_entries = array();
		foreach($entries as $entry){
			$entry = $this->format_entry($entry);
			if(empty($entry)) continue;
			if(!is_null($key_by)){
				if(!array_key_exists($key_by, $entry)){
					$this->error->notice('Skipping entry without a value for '.$this->error->describe($key_by).': '.sprp_for_log($entry));
					continue;
				}
				$formatted_entries[$entry[$key_by]] = $entry;
			}elseif(!empty($entry)){
				$formatted_entries[] = $entry;
			}
		}
		return $formatted_entries;
	}
	
	//based on this php.net comment: http://us2.php.net/manual/en/function.ldap-get-entries.php#Hcom89508
	protected function format_entry( $entry ) {
	  $formatted_entry = array();
	  for ( $i = 0; $i < $entry['count']; $i++ ) {
		if (is_array($entry[$i])) {
		  $subtree = $entry[$i];
		  if ( ! empty($subtree['dn']) and ! isset($formatted_entry[$subtree['dn']])) {
			$formatted_entry[$subtree['dn']] = $this->format_entry($subtree);
		  }
		  else {
			$formatted_entry[] = $this->format_entry($subtree);
		  }
		}
		else {
		  $attribute = $entry[$i];
		  if ( $entry[$attribute]['count'] == 1 ) {
			$formatted_entry[$attribute] = $entry[$attribute][0];
		  } else {
			for ( $j = 0; $j < $entry[$attribute]['count']; $j++ ) {
			  $formatted_entry[$attribute][] = $entry[$attribute][$j];
			}
		  }
		}
	  }
	  return $formatted_entry;
	}
	
	private function ldap_auth($username,$password,$find_dn = FALSE) {
		if($this->conn) {
			if($find_dn !== FALSE) {
				$ldap_bind = ldap_bind($this->conn, LDAP_SEARCH_USERNAME, LDAP_SEARCH_PASSWORD);
				$search = @ldap_search($this->conn, LDAP_ACCOUNTS_DN, "(&(uid=" . $username . "))", array("uid","dn"));
				$entry = @ldap_get_entries($this->conn, $search);
				if($entry["count"] == 1) {
					$ldap_bind = ldap_bind($this->conn, $entry[0]["dn"], $password); //bind with actual credentials
					if($ldap_bind) { 
						$groups = $this->get_admin_group_membership($entry[0]["dn"]);
						if($groups["count"] > 0) {
							$session_group_arr = array();
							for($i = 0; $i < $groups["count"]; $i++) {
								array_push($session_group_arr,$groups[$i]["dn"]);
							}
							$this->CI->session->set_userdata("groups",$session_group_arr);
						}
						return true; 
					}
				}
			}
			else { 
				$ldap_bind = ldap_bind($this->conn, $username, $password);
				if($ldap_bind) { return true; }
			}
		}
		return false;
	}
	
	public function ldap_escape ($str = '') {
		$metaChars = array ("\\00", "\\", "(", ")");
		$quotedMetaChars = array ();
		foreach ($metaChars as $key => $value) {
			$quotedMetaChars[$key] = '\\'. dechex (ord ($value));
		}
		$str = str_replace (
			$metaChars, $quotedMetaChars, $str
		); //replace them
		return ($str);
	}
	
	private function win_filetime_to_timestamp($filetime) {
		$win_secs = substr($filetime,0,strlen($filetime)-7); // divide by 10 000 000 to get seconds
		$unix_timestamp = ($win_secs - 11644473600); // 1.1.1600 -> 1.1.1970 difference in seconds
		return $unix_timestamp;
	}
	
	
	private function connect_to_ldap($username,$password,$find_dn = FALSE) {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return false; } 
		if (!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return false; }
		$this->conn = $ldap_conn; //temporarily set the connection to the one we made so we can check if binding works
		if(!$this->ldap_auth($username, $password, $find_dn)) { return false; }
		return $ldap_conn;
	}
}
?>